# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Initial move: Cooperate
    
    opponent_code_lower = opponent_program_code.lower()
    # Check for deterministic opponent strategies
    if "always cooperate" in opponent_code_lower or "return 'c'" in opponent_code_lower:
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_code_lower or "return 'd'" in opponent_code_lower:
        return "C"  # Minimize losses against always-defect
    
    current_round = len(my_history) + 1
    if current_round == 2:
        if opp_history[-1] == "C":
            return "C"
        else:
            return "D"
    elif current_round == 3:
        return opp_history[-1]  # Mirror opponent's round 2 move
    
    # Mid-game (rounds 4-7)
    if 4 <= current_round <= 7:
        if opp_history[:3].count("D") > 2:
            return "D"  # Grim trigger if opponent defected more than twice in first 3 rounds
        if random.random() < 0.2:
            return "C"  # 20% chance to forgive
        return opp_history[-1]  # Tit-for-tat
    
    # Late game (rounds 8-10)
    if current_round >= 8:
        if opp_history.count("D") > opp_history.count("C"):
            return "D"  # Defect if opponent has defected more
        else:
            return "C"  # Cooperate if opponent has mostly cooperated
    
    return "C"  # Default to cooperate